/****
 * CListingDocument.h
 *
 *	Listing Class for GW Ada.
 *

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.

 ****/

#define	_H_CListingDocument			/* Include this file only once */

#include <CDocument.h>
#include <CApplication.h>  
#include "MacAdaMrgp.h"

CLASS CSourceDocument;
CLASS CListingPane;
CLASS CStaticText;

struct CListingDocument : CDocument {
protected:
		CListingPane	*fTextEdit;
		CSourceDocument	*fSource;
		CStaticText		*fMessage;


		long			itsNumErrors;
		Msg				*itsErrors;
		long			itsCurrMsg;
public:

						/** Construction/Destruction **/
  			void        IListingDocument(CSourceDocument *source,
  							long numErrors,	Msg *p);

	virtual	void		Dispose(void);

	virtual	void		OpenFile(SFReply *macSFReply);
	virtual	void		BuildWindow (Handle theData);
	virtual	void		BuildWindowContents(void);

	virtual void		DoCommand(long theCommand);
			Boolean		CanCmdNext(void);
			Boolean		CanCmdPrev(void);
	virtual void		UpdateMenus(void);

	// Specialized behaviour
			long		GetNumErrors(void);
			void		GetNextError(long *fline, long *fcol,
									 long *tline, long *tcol);
			void		GetPrevError(long *fline, long *fcol,
									 long *tline, long *tcol);
};
